<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;
    protected $fillable = array('title', 'body', 'image', 'category_id');

    public function clients()
    {
        return $this->belongsToMany('App\Model\Post');
    }

    public function categories()
    {
        return $this->hasMany('App\Model\Category');
    }

}